/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.hook.HookWorld;
import com.charles445.rltweaker.reflect.SereneSeasonsReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SereneSeasonsHandler {
    SereneSeasonsReflect reflector;

    public SereneSeasonsHandler() {
        block3: {
            try {
                IEventListener listener;
                this.reflector = new SereneSeasonsReflect();
                if (ModConfig.server.sereneseasons.replaceRandomUpdateHandler && ModConfig.patches.chunkTicks && (listener = (IEventListener)CompatUtil.findAndRemoveHandlerFromEventBus("sereneseasons.handler.season.RandomUpdateHandler", "onWorldTick")) != null) {
                    RLTweaker.logger.info("Replacing SereneSeasons RandomUpdateHandler world tick");
                    HookWorld.sereneSeasonsPost = new SereneChunkTick(listener);
                }
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup SereneSeasonsHandler!", (Throwable)e);
                ErrorUtil.logSilent("Serene Seasons Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public class SereneChunkTick
    implements HookWorld.IChunkTickPost<SereneSeasonsReflect.SubSeason> {
        IEventListener handler;
        private boolean selfWorking;
        private int LCG = new Random().nextInt();
        private Map<ResourceLocation, Boolean> cachedBiomeSeasonalEffects;
        private Map<ResourceLocation, Boolean> cachedBiomeTropical;

        public SereneChunkTick(IEventListener handler) {
            this.handler = handler;
            this.selfWorking = true;
            MinecraftForge.EVENT_BUS.register((Object)this);
            try {
                this.cachedBiomeSeasonalEffects = SereneSeasonsHandler.this.reflector.createBiomeSeasonalEffects();
                this.cachedBiomeTropical = SereneSeasonsHandler.this.reflector.createBiomeTropicalSeasons();
            }
            catch (Exception e) {
                this.selfWorking = false;
                RLTweaker.logger.error("Failed to cache biome information!", (Throwable)e);
                ErrorUtil.logSilent("Serene Seasons Chunk Tick Biome Seasonal Effects");
            }
        }

        @SubscribeEvent
        public void onWorldTick(TickEvent.WorldTickEvent event) {
            if (!this.selfWorking || !HookWorld.chunkTickPatchEnabled) {
                this.handler.invoke((Event)event);
            }
        }

        @Override
        public SereneSeasonsReflect.SubSeason preUpdate(WorldServer world) {
            if (this.selfWorking) {
                try {
                    SereneSeasonsReflect.SubSeason subSeason = SereneSeasonsHandler.this.reflector.getSubSeason(SereneSeasonsHandler.this.reflector.getISeasonState((World)world));
                    SereneSeasonsReflect.Season season = subSeason.getSeason();
                    Object seasonConfig = SereneSeasonsHandler.this.reflector.getSeasonConfig();
                    boolean changeWeatherFrequency = SereneSeasonsHandler.this.reflector.getConfigChangeWeatherFrequency(seasonConfig);
                    WorldInfo worldinfo = world.func_72912_H();
                    if (season == SereneSeasonsReflect.Season.WINTER) {
                        if (changeWeatherFrequency) {
                            if (worldinfo.func_76061_m()) {
                                worldinfo.func_76069_a(false);
                            }
                            if (!worldinfo.func_76059_o() && worldinfo.func_76083_p() > 36000) {
                                worldinfo.func_76080_g(world.field_73012_v.nextInt(24000) + 12000);
                            }
                        }
                    } else {
                        if (changeWeatherFrequency) {
                            if (season == SereneSeasonsReflect.Season.SPRING) {
                                if (!worldinfo.func_76059_o() && worldinfo.func_76083_p() > 96000) {
                                    worldinfo.func_76080_g(world.field_73012_v.nextInt(84000) + 12000);
                                }
                            } else if (season == SereneSeasonsReflect.Season.SUMMER && !worldinfo.func_76061_m() && worldinfo.func_76071_n() > 36000) {
                                worldinfo.func_76090_f(world.field_73012_v.nextInt(24000) + 12000);
                            }
                        }
                        if (SereneSeasonsHandler.this.reflector.getConfigGenerateSnowAndIce(seasonConfig) && SereneSeasonsHandler.this.reflector.isDimensionWhitelisted(world.field_73011_w.getDimension())) {
                            return subSeason;
                        }
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    this.selfWorking = false;
                    RLTweaker.logger.error("Failed to run Serene Seasons Chunk Tick! Returning to default behavior.", (Throwable)e);
                    ErrorUtil.logSilent("Serene Seasons Chunk Tick Invocation");
                }
            }
            return null;
        }

        @Override
        public void invoke(Chunk chunk, SereneSeasonsReflect.SubSeason companion) {
            int updateLCG;
            int randVal = 4;
            switch (companion) {
                case EARLY_SPRING: {
                    randVal = 16;
                    break;
                }
                case MID_SPRING: {
                    randVal = 12;
                    break;
                }
                case LATE_SPRING: {
                    randVal = 8;
                    break;
                }
            }
            if (chunk.func_177412_p().field_73012_v.nextInt(randVal) != 0) {
                return;
            }
            int blockX = chunk.field_76635_g << 4;
            int blockZ = chunk.field_76647_h << 4;
            World world = chunk.func_177412_p();
            this.LCG = updateLCG = this.LCG * 3 + 1013904223;
            int chunkOffset = updateLCG >> 2;
            BlockPos pos = chunk.func_177440_h(new BlockPos(blockX + (chunkOffset & 0xF), 0, blockZ + (chunkOffset >> 8 & 0xF)));
            Biome biome = chunk.func_177411_a(pos, world.func_72959_q());
            if (Objects.equals(this.cachedBiomeSeasonalEffects.get(biome.getRegistryName()), false)) {
                return;
            }
            boolean firstRun = true;
            int posX = pos.func_177958_n();
            int posZ = pos.func_177952_p();
            for (int posY = pos.func_177956_o(); posY >= 0; --posY) {
                Block block = chunk.func_186032_a(posX, posY, posZ).func_177230_c();
                if (block == Blocks.field_150431_aC && this.getUnsafeTemperature(chunk, biome, pos = new BlockPos(posX, posY, posZ), companion) >= 0.15f) {
                    world.func_175698_g(pos);
                    break;
                }
                if (!firstRun) {
                    if (block != Blocks.field_150432_aD || !(this.getUnsafeTemperature(chunk, biome, pos = new BlockPos(posX, posY, posZ), companion) >= 0.15f)) continue;
                    try {
                        SereneSeasonsHandler.this.reflector.turnIntoWater(block, world, pos);
                        break;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        this.selfWorking = false;
                        RLTweaker.logger.error("Failed to run Serene Seasons Chunk Tick! Ice broke. Returning to default behavior.", (Throwable)e);
                        ErrorUtil.logSilent("Serene Seasons Chunk Tick Invocation Ice");
                        return;
                    }
                }
                firstRun = false;
            }
        }

        private float getUnsafeTemperature(Chunk chunk, Biome biome, BlockPos pos, SereneSeasonsReflect.SubSeason subseason) {
            float baseTemp = biome.func_180626_a(pos);
            if (biome.func_185353_n() > 0.8f) {
                return baseTemp;
            }
            if (Objects.equals(this.cachedBiomeTropical.get(biome.getRegistryName()), true)) {
                return baseTemp;
            }
            switch (subseason) {
                case LATE_SPRING: 
                case EARLY_AUTUMN: {
                    return baseTemp - 0.1f;
                }
                case MID_SPRING: 
                case MID_AUTUMN: {
                    return baseTemp - 0.2f;
                }
                case EARLY_SPRING: 
                case LATE_AUTUMN: {
                    return baseTemp - 0.4f;
                }
            }
            return baseTemp;
        }
    }
}

